﻿class com.arn.ui.SliderBar
{
    var addListener, debug, dir, dragBtn, dragBar, initLoc, minValue, maxValue, __set__active, __name, __get__name, __get__pressed, _active, __get__active, broadcastMessage, getvalue_int, __set__name, __set__pressed;
    function SliderBar(dBtn, dBar, d, init)
    {
        AsBroadcaster.initialize(this);
        this.addListener(this);
        debug = {};
        debug.trace = trace;
        if (dBtn && dBar && d)
        {
            if (!com.arn.utils.VarUtil.checkValue(d, "vertical,horizontal"))
            {
                debug.error("Direction must be either \"horizontal\" or \"vertical\"");
            }
            else
            {
                dir = d.toLowerCase() == "vertical" ? ("v") : ("h");
            } // end else if
            dragBtn = dBtn;
            dragBar = dBar;
            initLoc = init.startLoc ? (init.startLoc.toLowerCase()) : ("start");
            if (!com.arn.utils.VarUtil.checkValue(initLoc, "start,center"))
            {
                debug.error("startLoc property must be either \"center\" or \"start\"");
            } // end if
            minValue = !isNaN(init.min) ? (init.min) : (0);
            maxValue = !isNaN(init.max) ? (init.max) : (100);
            if (dir == "v" && initLoc == "start")
            {
                dragBtn._y = dragBar._y;
            }
            else if (dir == "h" && initLoc == "start")
            {
                dragBtn._x = dragBar._x;
            }
            else if (dir == "v" && initLoc == "center")
            {
                dragBtn._y = dragBar._y + dragBar._height / 2;
            }
            else if (dir == "h" && initLoc == "center")
            {
                dragBtn._x = dragBar._x + dragBar._width / 2;
            } // end else if
            if (!init.controlled)
            {
                this.__set__active(true);
            } // end if
            if (init.pressed == true)
            {
                this.dragPress();
            } // end if
        }
        else
        {
            debug.error("Please initialize SliderBar with \"new SliderBar(dragHandle:Movieclip,dragGuide:Movieclip,direction:String);\"");
        } // end else if
    } // End of the function
    function set name(n)
    {
        __name = n;
        //return (this.name());
        null;
    } // End of the function
    function set pressed(b)
    {
        if (b == true)
        {
            this.dragPress();
        }
        else
        {
            this.dragRelease();
        } // end else if
        //return (this.pressed());
        null;
    } // End of the function
    function set active(val)
    {
        _active = val;
        if (_active)
        {
            dragBtn.onRollOver = mx.utils.Delegate.create(this, dragRollOver);
            dragBtn.onRollOut = mx.utils.Delegate.create(this, dragRollOut);
            dragBtn.onPress = mx.utils.Delegate.create(this, dragPress);
            dragBtn.onRelease = mx.utils.Delegate.create(this, dragRelease);
            dragBtn.onReleaseOutside = mx.utils.Delegate.create(this, dragRelease);
        }
        else
        {
            delete dragBtn.onRollOver;
            delete dragBtn.onRollOut;
            delete dragBtn.onPress;
            delete dragBtn.onRelease;
            delete dragBtn.onReleaseOutside;
        } // end else if
        //return (this.active());
        null;
    } // End of the function
    function setRange(min, max)
    {
        if (min == undefined || max == undefined)
        {
            debug.error("When setting a range, both the minimum and maximum have to be set.");
        }
        else
        {
            minValue = min;
            maxValue = max;
        } // end else if
    } // End of the function
    function getRange()
    {
        return ({min: minValue, max: maxValue});
    } // End of the function
    function dragRollOver()
    {
        this.broadcastMessage("onDragRollOver", dragBtn._parent);
    } // End of the function
    function dragRollOut()
    {
        this.broadcastMessage("onDragRollOut", dragBtn._parent);
    } // End of the function
    function dragPress()
    {
        if (dir == "h")
        {
            dragBtn.startDrag(false, dragBar._x, dragBtn._y, dragBar._x + dragBar._width, dragBtn._y);
        }
        else
        {
            dragBtn.startDrag(false, dragBtn._x, dragBar._y, dragBtn._x, dragBar._y + dragBar._height);
        } // end else if
        this.broadcastMessage("onDragPress", dragBtn._parent);
        clearInterval(getvalue_int);
        getvalue_int = setInterval(this, "dragUpdate", 50);
    } // End of the function
    function dragRelease()
    {
        dragBtn.stopDrag();
        this.broadcastMessage("onDragRelease", dragBtn._parent);
        this.broadcastMessage("onDragReleaseOutside", dragBtn._parent);
        clearInterval(getvalue_int);
    } // End of the function
    function dragUpdate()
    {
        this.broadcastMessage("onDragUpdate", this.getCurrentValue(), dragBtn._parent);
    } // End of the function
    function getCurrentValue()
    {
        var _loc2;
        var _loc3;
        if (dir == "h")
        {
            _loc2 = dragBtn._x - dragBar._x;
            _loc3 = Math.round(_loc2 / dragBar._width * 100);
        }
        else
        {
            _loc2 = dragBtn._y - dragBar._y;
            _loc3 = Math.round(_loc2 / dragBar._height * 100);
        } // end else if
        return ((maxValue - minValue) * _loc3 / 100 + minValue);
    } // End of the function
    function setValue(val, animate, props)
    {
        if (val < Math.min(minValue, maxValue) || val > Math.max(minValue, maxValue))
        {
            trace ("out of range");
            return;
        } // end if
        var _loc4 = (val - minValue) / (maxValue - minValue);
        var _loc3 = dir == "h" ? (dragBar._width * _loc4 + dragBar._x) : (dragBtn._x);
        var _loc2 = dir == "v" ? (dragBar._height * _loc4 + dragBar._y) : (dragBtn._y);
        if (animate)
        {
            gs.TweenLite.to(dragBtn, props.duration || 0.500000, {_x: _loc3, _y: _loc2, onUpdate: mx.utils.Delegate.create(this, dragUpdate)});
        }
        else
        {
            dragBtn._x = _loc3;
            dragBtn._y = _loc2;
            this.dragUpdate();
        } // end else if
    } // End of the function
} // End of Class
