﻿class com.wallst.adhesion.AdBase extends MovieClip
{
    var _symbol, __get__defaultSymbol, __get__symbol, _company, __get__defaultName, __get__company, __get__defaultClickthrough, __get__environment, __get__aspClassicHost, __get__clientId, __get__aspNetHost, __get__aspNetServiceBase, __get__aspClassicServiceBase, __set__company, __get__context, __get__issueType, __get__recent, __set__symbol;
    function AdBase()
    {
        super();
    } // End of the function
    function get defaultSymbol()
    {
        return ("SPX");
    } // End of the function
    function get defaultName()
    {
        return ("S&P 500 Index");
    } // End of the function
    function get defaultClickthrough()
    {
        throw new Error("A default clickthrough URL was not specified.");
    } // End of the function
    function get symbol()
    {
        if (!_symbol)
        {
            _symbol = _root.symbol || this.__get__defaultSymbol();
        } // end if
        return (_symbol);
    } // End of the function
    function set symbol($)
    {
        _symbol = $;
        //return (this.symbol());
        null;
    } // End of the function
    function get company()
    {
        if (!_company)
        {
            _company = _root.name || (this.__get__symbol() == this.__get__defaultSymbol() ? (this.__get__defaultName()) : (this.__get__symbol()));
        } // end if
        return (_company);
    } // End of the function
    function set company($)
    {
        _company = $;
        //return (this.company());
        null;
    } // End of the function
    function get issueType()
    {
        return (_root.issue_type || "");
    } // End of the function
    function get recent()
    {
        return (_root.recent);
    } // End of the function
    function get context()
    {
        return ({domain: _root.domain || "", section: _root.section || "", subsection: _root.subsection || ""});
    } // End of the function
    function addClickHandler(mc)
    {
        if (!mc.getURL)
        {
            throw new Error("Click target must be an instance of a MovieClip");
        } // end if
        var self = this;
        mc.onRelease = function ()
        {
            self.clickHandler(mc);
        };
    } // End of the function
    function clickHandler(mc)
    {
        var _loc3 = _root.clickTag || this.__get__defaultClickthrough();
        var _loc4 = flash.external.ExternalInterface.available;
        if (_loc4 && _root.oobclick)
        {
            var _loc5 = Boolean(flash.external.ExternalInterface.call("wsodOOBClick"));
            if (_loc5)
            {
            } // end if
        } // end if
        mc.getURL(_loc3, "_blank");
    } // End of the function
    function get clientId()
    {
        throw new Error("Must specify a valid Client ID to access core services");
    } // End of the function
    function get environment()
    {
        return ("Production");
    } // End of the function
    function get aspClassicHost()
    {
        var _loc2 = {Dev: "http://dev2.wallst.com", Test: "http://addata.wsodqa.com", Production: "http://api.addata.wallst.com"};
        //return (_loc2[this.environment()]);
    } // End of the function
    function get aspClassicServiceBase()
    {
        var _loc2 = {Dev: "/addata/services/", Test: "/services/", Production: "/services/"};
        //return (this.aspClassicHost() + _loc2[this.__get__environment()] + this.__get__clientId() + "/");
    } // End of the function
    function aspClassicService(service, onComplete, params)
    {
    } // End of the function
    function get aspNetHost()
    {
        var _loc2 = {Local: "http://localhost", Dev: "http://dev3.wallst.com", Test: "http://addata.wsodqa.com", Production: "http://api.addata.wallst.com"};
        //return (_loc2[this.environment()]);
    } // End of the function
    function get aspNetServiceBase()
    {
        var _loc2 = {Local: "/addata/dotnetservices/", Dev: "/addata/dotnetservices/", Test: "/net/", Production: "/net/"};
        //return (this.aspNetHost() + _loc2[this.__get__environment()] + this.__get__clientId() + "/");
    } // End of the function
    function aspNetService(service, onComplete, params)
    {
        var _loc2 = this.loadUrl(this.__get__aspNetServiceBase() + service + "/json", params);
        _loc2.onData = function (data)
        {
            if (data)
            {
                var _loc1 = org.json.JSON.parse(data);
            } // end if
            if (onComplete)
            {
                onComplete(_loc1);
            } // end if
        };
        return (_loc2);
    } // End of the function
    function aspClassicImage(path, container, onComplete)
    {
        var _loc2 = this.__get__aspClassicHost() + path;
        container.loadMovie(_loc2);
    } // End of the function
    function aspNetImage(path, container, onComplete)
    {
        var _loc2 = this.__get__aspNetHost() + path;
        container.loadMovie(_loc2);
    } // End of the function
    function loadUrl(url, params)
    {
        var _loc5 = new LoadVars();
        if (params)
        {
            var _loc1 = true;
            for (var _loc4 in params)
            {
                url = url + ((_loc1 ? ("?") : ("&")) + escape(_loc4) + "=" + escape(params[_loc4]));
                _loc1 = false;
            } // end of for...in
        } // end if
        _loc5.load(url);
        return (_loc5);
    } // End of the function
    function setCompanyText(textObject, prefix, suffix, minSize, vAdjust)
    {
        prefix = prefix || "";
        suffix = suffix || "";
        minSize = minSize || 10;
        vAdjust = vAdjust || 0.750000;
        textObject.text = prefix + this.__get__company() + suffix;
        var _loc2 = textObject.getTextFormat();
        var _loc4 = textObject._width - _loc2.leftMargin - _loc2.rightMargin - 5;
        var _loc9 = textObject._y;
        if (_loc4 < textObject.textWidth)
        {
            if (this.__get__company().substr(-6, 6) == " Index")
            {
                textObject.text = prefix + this.__get__company().substr(0, this.__get__company().length - 6) + suffix;
            } // end if
            if (this.__get__company().substr(-5, 5) == " Corp")
            {
                textObject.text = prefix + this.__get__company().substr(0, this.__get__company().length - 5) + suffix;
            } // end if
            if (this.__get__company().substr(-4, 4) == " Inc")
            {
                textObject.text = prefix + this.__get__company().substr(0, this.__get__company().length - 4) + suffix;
            } // end if
        } // end if
        while (_loc4 < textObject.textWidth && _loc2.letterSpacing > -0.750000)
        {
            _loc2.letterSpacing = _loc2.letterSpacing - 0.150000;
            textObject.setTextFormat(_loc2);
        } // end while
        while (_loc4 < textObject.textWidth && _loc2.size > minSize)
        {
            _loc2.size = _loc2.size - 1;
            textObject.setTextFormat(_loc2);
            textObject._y = textObject._y + vAdjust;
        } // end while
        while (_loc4 > textObject.textWidth && _loc2.letterSpacing < 0)
        {
            _loc2.letterSpacing = _loc2.letterSpacing + 0.050000;
            textObject.setTextFormat(_loc2);
        } // end while
        if (_loc4 < textObject.textWidth)
        {
            _loc2.letterSpacing = _loc2.letterSpacing - 0.050000;
            textObject.setTextFormat(_loc2);
        } // end if
        if (_loc4 < textObject.textWidth)
        {
            textObject.text = prefix + this.__get__symbol() + suffix;
            textObject._y = _loc9;
        } // end if
    } // End of the function
} // End of Class
